/*******************************************************************************
 *
 *  hal_board.c
 *
 *  Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************/

#include "msp430.h"
#include "hal_board.h"

/**********************************************************************//**
 * @brief  Initializes ACLK, MCLK, SMCLK outputs on P11.0, P11.1,
 *         and P11.2, respectively.
 *
 * @param  none
 *
 * @return none
 *************************************************************************/

void halBoardOutputSystemClock(void) //outputs clock to testpoints
{
    CLK_PORT_DIR |= 0x07;
    CLK_PORT_SEL |= 0x07;
}

/**********************************************************************//**
 * @brief  Stops the output of ACLK, MCLK, SMCLK on P11.0, P11.1, and P11.2.
 *
 * @param  none
 *
 * @return none
 *************************************************************************/

void halBoardStopOutputSystemClock(void)
{
    CLK_PORT_OUT &= ~0x07;
    CLK_PORT_DIR |= 0x07;
    CLK_PORT_SEL &= ~0x07;
}

/**********************************************************************//**
 * @brief  Initializes all GPIO configurations.
 *
 * @param  none
 *
 * @return none
 *************************************************************************/

void halBoardInit(void)
{
    //Tie unused ports
    PAOUT  = 0;
    PADIR  = 0xFFFF;
    PASEL  = 0;
    PBOUT  = 0;
    PBDIR  = 0xFFFF;
    PBSEL  = 0;
    PCOUT  = 0;
    PCDIR  = 0xFFFF;
    PCSEL  = 0;
    PDOUT  = 0;
    PDDIR  = 0xFFFF;
    PDSEL  = 0x0003;
    PEOUT  = 0;
    PEDIR  = 0xFEFF;                        // P10.0 to USB RST pin,
                                            // ...if enabled with J5
    PESEL  = 0;
    P11OUT = 0;
    P11DIR = 0xFF;
    PJOUT  = 0;
    PJDIR  = 0xFF;
    P11SEL = 0;

	/* Initialize CC3000 GPIO Interface */
    P1DIR &= ~WLAN_IRQ_PIN;                 // RF_IRQ_PIN is input
	P1REN |= WLAN_IRQ_PIN;					//Enable pullup
    
	P1OUT &= ~WLAN_EN_PIN;                 // RF_EN_PIN
    P1DIR |= WLAN_EN_PIN;
	
    // Configure LED ports
    LED_PORT_OUT &= ~(LED_2 + LED_1);
    LED_PORT_DIR |= (LED_2 + LED_1);	
}

/***************************************************************************//**
 * @brief  Turn on LEDs
 * @param  ledMask   Use values defined in HAL_board.h for the LEDs to turn on
 * @return none
 ******************************************************************************/

void halBoardLedOn(uint8_t ledMask)
{
    if (ledMask & LED_1) LED_PORT_OUT |= BIT0;
    if (ledMask & LED_2) LED_PORT_OUT |= BIT1;
}

/***************************************************************************//**
 * @brief  Turn off LEDs
 * @param  ledMask   Use values defined in HAL_board.h for the LEDs to turn off
 * @return none
 ******************************************************************************/

void halBoardLedOff(uint8_t ledMask)
{
    if (ledMask & LED_1) LED_PORT_OUT &= ~BIT0;
    if (ledMask & LED_2) LED_PORT_OUT &= ~BIT1;
}

/***************************************************************************//**
 * @brief  Toggle LEDs
 * @param  ledMask   Use values defined in HAL_board.h for the LEDs to toggle
 * @return none
 ******************************************************************************/

void halBoardLedToggle(uint8_t ledMask)
{
    if (ledMask & LED_1) LED_PORT_OUT ^= BIT0;
    if (ledMask & LED_2) LED_PORT_OUT ^= BIT1;
}
